﻿using gov.va.med.vbecs.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace gov.va.med.vbecs.GUI.controls
{
    /// <summary>
    /// Extended TextBox control with additional Barcode property. Used on WinForm and WPF BarcodeTextbox controls
    /// </summary>
    public class BarcodeTextboxBase : NotifyPropertyChanged
    {
        #region Properties  
        private Common.BarcodeType barcodeType;
        /// <summary>
        /// BarcodeTextbox conrtrol class constructor. Creates the instance of the control.
        /// </summary>        
        public Common.BarcodeType BarcodeType
        {
            get
            {
                return barcodeType;
            }
            set
            {
                barcodeType = value;
                RaisePropertyChanged(() => BarcodeType);
            }
        }

        private bool barcode;
        /// <summary>
        /// Determines if entry made by barcode. Returns true if entry was made by scanning a barcode.
        /// </summary>
        public bool Barcode
        {
            get
            {
                return this.barcode;
            }
            set
            {
                this.barcode = value;
                RaisePropertyChanged(() => BarcodeType);
            }
        }

        #endregion

        /// <summary>
        /// BarcodeTextboxBase Constructor
        /// </summary>
        public BarcodeTextboxBase()
        {
            barcode = false;
            barcodeType = Common.BarcodeType.None;
        }

        ///<Developers>
        ///	<Developer>Doug Forst</Developer>
        ///</Developers>
        ///<SiteName></SiteName>
        ///<CreationDate>12/21/2015</CreationDate>
        ///
        /// <summary>
        /// Override for KeyPress event. Checks for ~ character which denotes a barcode was scanned.
        /// </summary>
        /// <param name="selectedText"></param>
        /// <param name="text"></param>
        /// <param name="keyPressedChar"></param>
        public bool HandleKeyPress(string selectedText, string text, char keyPressedChar)
        {
            bool handled = false;

            if (selectedText.Length == text.Length || text.Length <= 1)
            {
                if (keyPressedChar == '~')
                {
                    Barcode = true;
                    handled = true;
                }
            }
            else
            {
                if (keyPressedChar == (char)13)
                {
                    handled = true;
                }
            }

            return handled;
        }

        /// <summary>
        /// Implements BR_1.04
        /// Handles the resetting of the barcode indicator to it's default state.
        /// </summary>
        /// <param name="text"></param>
        public void OnTextChanged(string text)
        {            
            if (text.IndexOf("=") > -1)
            {
                BarcodeType = Common.BarcodeType.ISBT128;
            }
            else if (text.IndexOf("<") > -1)
            {
                BarcodeType = Common.BarcodeType.ISBT128;
            }
            else if (text.IndexOf("(") > -1)
            {
                BarcodeType = Common.BarcodeType.ISBT128;
            }
            else if (text.IndexOf("%") > -1)
            {
                BarcodeType = Common.BarcodeType.ISBT128;
            }
            else if (text.IndexOf("&>") > -1)
            {
                BarcodeType = Common.BarcodeType.ISBT128;
            }
            else
            {
                BarcodeType = Common.BarcodeType.Codabar;
            }

            if (text.Length == 0)
            {
                Barcode = false;
            }
        }
    }
}

